/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;

public class ArmorPyroElectricModifier
extends Modifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> PYRO = TConstruct.createKey((String)"pyro_armor");

    public ArmorPyroElectricModifier() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOW, ArmorPyroElectricModifier::onHurt);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addModule((HookProvider)new ArmorLevelModule(PYRO, false, null));
    }

    private static void onHurt(LivingHurtEvent event) {
        LivingEntity living = event.getEntity();
        living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
            int level = (Integer)holder.get(PYRO, (Object)0);
            if (level > 0 && event.getAmount() != 0.0f) {
                BlockPos pos = living.m_20097_();
                Level world = living.m_9236_();
                float temp = ((Biome)world.m_204166_(pos).m_203334_()).m_47554_();
                if (living.m_6060_()) {
                    temp += 0.3f;
                }
                if ((double)temp < 0.15) {
                    return;
                }
                float damage = temp * 3.0f;
                List list = world.m_45976_(Mob.class, new AABB(living.m_20185_() - (double)(5 * level), living.m_20186_() - (double)(5 * level), living.m_20189_() - (double)(5 * level), living.m_20185_() + (double)(5 * level), living.m_20186_() + (double)(5 * level), living.m_20189_() + (double)(5 * level)));
                if (!world.f_46443_) {
                    for (Mob en : list) {
                        if (en == living) continue;
                        en.f_19802_ = 0;
                        en.m_6469_(DamageSource.f_19306_, damage);
                    }
                }
            }
        });
    }
}

